.TH REDIFNET 1V  "" "Valid Logic"
.ds GD /usr/valid/tools/redifnet/redifnet.cmd
.SH NAME
redifnet \- EDIF to GED netlist reader
.SH SYNOPSIS
.B redifnet 
[\fB-p\fP \fIpinMap\fP]...  [\fB-prop\fP \fIpropertyMap\fP] [\fB-source\fP \fIsourceName\fP] \fIedifNetlistFile\fP 
.SH DESCRIPTION
.B redifnet
reads EDIF netlist view file, then creates GED body file(s) and connectivity
file(s).  

The \fB-p\fP option is used to activate pin maps.  Details about pin maps are explained in the following sections.  

The \fB-prop\fP option is used to activate a property map.  Details about property 
map are explained in the following sections.

The \fB-source\fP option allows the user to
specify the vendor producing the EDIF file.  

A directives file \fBredifnet.cmd\fP, is read to determine the Scald directory
within which to place the drawings found in the EDIF file.  Other
options that can be activated in the directives file are discussed in the 
following section.   
It is case insensitive except file name specifications.
Directives to be used by all can be specified in the global directives file
\fB\*(GD\fP.
If neither \fBredifnet.cmd\fP nor \fB\*(GD\fP is present in the current directory,
then default options will be used.
.SH EXAMPLES 
Translate a file called \fItest_1.edif\fP:
.IP
\fBredifnet   test_1.edif\fP

.RE
Translate a file called \fIValid_2.edif\fP, generated by Valid Logic Systems:
.RS
.IP
\fBredifnet   -source   VALID   Valid_2.edif\fP

.RE
Translate a file called \fItest_3.edif\fP, and use a pin map file called
\fIpinMap_3\fP: 
.RS
.IP
\fBredifnet   -p   pinMap_3   test_3.edif\fP

.RE
Translate a file called \fItest_4.edif\fP, and use a property map file called
\fIpropMap_4\fP: 
.RS
.IP
\fBredifnet   -prop   propMap_4   test_4.edif\fP

.RE
Translate a file called \fIValid_5.edif\fP, generated by Valid Logic Systems,
using a pin map file called 
\fIpinMap_5\fP and a property map file called \fIpropMap_5\fP: 
.RS
.IP
\fBredifnet   -p   pinMap_5   -prop   propMap_5   -source   VALID   Valid_5.edif\fP

.RE
\fBNote:\fP the options used in the examples above can also be specified in the
directive file \fIredifnet.cmd\fP.
.SH DIRECTIVES 
.LP
The following directives are permitted in the directives file \fBredifnet.cmd\fP.
If multiple sources are specified in the directive file, the last one is used by the
translator.  If no source is specified, \fBGENERIC\fP is the default value. 
.LP
.B SOURCE
[
.B ALTERA
|
.B SYNOPSYS
|
.B MENTOR
|
.B VALID 
|
.B VIEWLOGIC
| 
.B GENERIC
] 
.B ; 
.IP 
Informs the reader about the vendor producing the edif file, 
so that the results can be tuned according to the idiosyncracies of that source.  
In particular, signal names must be parsed in order to replace them with 
Valid signal names that can be understood by Valid netlist compiler. 
\fBGENERIC\fP provides no source-dependent tuning.  
.LP 
.B DIRECTORY 
scald_directory_name
.B ;
.IP
Use the specified scald directory for output.
.IP
If not specified, the
library names specified by the EDIF file will be used (with the suffix
.B .lib
appended).
.LP
.B GENERATE_FLAGS
[
.B ON
|
.B OFF
]
.B ;
.IP
If
.B ON,
Valid-style FLAG bodies will be generated for each interface signal.
These are currently produced on additional pages.  
If
.B OFF,
interface signals remain unflagged.
.LP
.B INSTANCE_NAME
[
.B OFF
|
.B ON
|
property_name
]
.B ;
.IP
Determines the treatment of the
instance names specified in the EDIF file.
The instance name in the EDIF file will be made the value of the specified property, which will be
attached to the instance.  Interesting values are \fBPATH\fP and \fBLOCATION\fP.
For any value other than \fBPATH\fP, path properties will be generated in the
usual Valid style.  Note that a property name is an \fIidentifier\fP, not a
quoted string -- don't enclose it in quotes.
.IP
If \fBOFF\fP, the instance names in the EDIF file are ignored.  \fBON\fP is
considered to be a synonym for \fBPATH\fP.
.LP
.B EDIF_BODY
body_version
.B ;
.IP
Controls the (first)
body version to be used in the generation of body files as
specified by the EDIF.  These bodies are \fBalways\fP generated when generating
netlist -- only the version number can be controlled.
By default, these are generated as body version 1 (and ascending, when
multiple views exist for a cell).  These body files are to be used by the Valid
compiler, and should not be regarded as symbols to be displayed.
.LP
.B VECTORIZE
[
.B ON
|
.B OFF
]
.B ;
.IP
.B THIS DIRECTIVE IS SYNOPSYS-SPECIFIC.
.IP
If
.B ON,
Pin/signal names of the form foo\fB_\fP\fInumber\fP, or foo\fB-\fP\fInumber\fP,
or foo\fB.\fP\fInumber\fP, will be converted
to foo\fB<\fP\fInumber\fP\fB>\fP
and bodies generated for them will have the individual bits merged into a
vector.
If
.B OFF,
this is not done.
.LP
\fBPIN_MAP_FILE\fP [\fB-\fP]file_name [\fB,\fP [\fB-\fP]file_name ]... \fB;\fP
.IP
Libraries of a vendor may differ from Valid libraries in the naming of some pins.
Usually, these differ in only subtle ways, such as a pin named \fBA\fP in the Synopsys
library but named \fBA<size-1..0>\fP in the Valid library.  A pin map file must be
constructed to map such pins from their Synopsys name to their Valid name for SIZE=1.
.IP
This directive causes
the named pin-map files to be read and used to map the specified pin names
between the vendor libraries and the Valid libraries.  The contents of these
files is discussed below in a separate section.
If a file name is
preceded by a '-', then the sense of its source and destination pins is
reversed.  The file names themselves must always be quoted.
.IP
Alternatively, this directive can be specified on the command line
as one or more flags of the form
.nf
    \fB-p\fP [\fB-\fP]file_name
.fi
This is useful for wrapping \fIredifnet\fP in a script that calls the proper
pin map files
(as set up by the librarian) so that individual users will not
need to worry about this.
.LP
\fBIGNORED_PROPERTIES\fP [\fIpropertyName\fP] [, \fIpropertyName\fP]... \fB;\fP
.IP
The specified \fIpropertyName\fP(s) will not show up in the connectivity files.
.LP
\fBPOWER_PIN\fP "\fIpowerSignalName\fP" [, "\fIpowerSignalName\fP"]... \fB;\fP
.IP
Signals connected with the \fIpowerSignalName\fP(s) will appear in the connectivity files
with "1" designated.
.LP
\fBGROUND_PIN\fP "\fIgroundSignalName\fP" [, "\fIgroundSignalName\fP"]... \fB;\fP
.IP
Signals connected with the \fIgroundSignalName\fP(s) will appear in the connectivity files
with "0" designated.
.SH FILES
.br
.nf
\fBredifnet.cmd\fP - directives file (input)
\fIanyFileName\fP - EDIF file (input)
\fIanyFileName\fP - pin map file (input)
\fIanyFileName\fP - property map file (input)
\fIGedDrawings\fP - Directories which contains GED body file(s) and connectivity
                    file(s) (output)
.fi
.SH DIAGNOSTICS
.LP
Syntax errors in the EDIF or directives files
are reported as such, with line number.  All syntax errors in the EDIF
or pin map files
are fatal, as are most in the directives file.
.LP
Semantic errors in the EDIF (or pin map) files
are reported as such but are not fatal.
.SH PIN MAP FILE
.LP
As described above, pin map file can be used to rename an original
cell name to a new cell name, or, rename an original pin name of a
cell to a new pin name.  This is necessary when the result of the
translation needs to be simulated.
.LP
The syntax is:
.IP
.nf
pin_map_file :== \fBFILE_TYPE = PIN_MAP;\fP part_list \fBEND .\fP
part_list :== part_list part | null
part :== \fBPRIMITIVE\fP part_name \fB;\fP pin_list \fBEND_PRIMITIVE;\fP
pin_list :== pin_list pin | null
pin :== source_pin_name subscript \fB:\fP dest_pin_name subscript \fB:\fP pin_direction \fB;\fP
part_name :== quoted_string dest_part_name
dest_part_name :== \fB:\fP quoted_string | null
source_pin_name :== quoted_string
dest_pin_name :== quoted_string
subscript :== \fB<\fP bit \fB>\fP | null
pin_direction :== \fBINPUT\fP | \fBOUTPUT\fP | \fBBIDIR\fP | \fBINOUT\fP
.fi
.LP
(\fBBIDIR\fP and \fBINOUT\fP are equivalent).
All identifiers and strings are case-insensitive.  Low asserted pins are
indicated with a preceding '-' in the pin name, as is done in compiler expansion
files and chips files.
For example:
.IP
.nf
file_type = pin_map;
primitive 'iv' : 'your iv';
    'a' : 'a'<0> : input;
    'z' : '-z'<0> : output;
end_primitive;
end.
.fi
.SH PROPERTY MAP FILE
.LP
Property file is used to map properties, parameters, or to ignore certain or
all properties of a cell.
.IP
.nf

1. A property map file does not attempt to handle all properties defined by
   EDIF. Only the properties of the following objects are handled.

      Cell
      Port
      PortBundle
      Instance
      PortInstance
      Net
      NetBundle
  
2. These properties can be mapped into the following objects defined in GED

      signal
      pin
      instance
      body
      PinInstance
   
3. The default mappings are as follows:

   EDIF                  GED
   ----------------------------------------
   Cell                   Body
   Port                   pin
   PortBundle           pin
   Instance              instance
   PortInstance         PinInstance
   Net                    Signal
   NetBundle            Signal

4. THe syntax for property mapping

   prop_map_file : header prim.list end
                 ;
   header      : FILE_TYPE '=' PROPERTY_MAP ';'
                 ;
   end          : END.
                 ;
   prim.list    : <nothing> 
                 | prim.list prim
                 ;
   prim         : prim_head primitive prim_end
                 ;
   prim_head  : PRIMITIVE <ID> ';'
                 | PRIMITIVE ';' 
                 ;
   prim_end   : END_PRIMITIVE ';'
                 ;
   primitive   : map
                 | ignore
                 | primitive map
                 | primitive ignore
                 ;
   
   map         : MAP prop_or_para <ID> ':' prop_or_para <ID> ':' prop_type ';'
                 | MAP prop_or_para <ID> ':' prop_or_para <ID> ';'
                 ;
   ignore      : IGNORE prop_or_para <ID> ':' prop_type ';'
                 | IGNORE prop_or_para <ID> ';'
                 ;
   prop_type  : CELL          
                 | BODY         
                 | PORT        
                 | PIN        
                 | INSTANCE  
                 | PORTINSTANCE  
                 | PININSTANCE  
                 | NET         
                 | SIGNAL     
                 | ALL        
                 ;
   prop_or_para  : PROPERTY   
                 | PARAMETER  
                 | /*nothing*/ 
                 ;
   
.LP
An example property map file:

.IP
file_type = property_map ;

primitive;   { This portion applies to all cells. }
   map    property tpd : parameter delay : instance;
   map    property portpropd : parameter pd : port;
   { ignore property netdelay : net; }
   ignore property label;
end_primitive;

primitive cell_2;   { This applies to cell_2 only. }
   map    property pd : property port_delay : portInstance;
end_primitive;

end.
.fi
